#include <iostream>
#include <vector>
using namespace std;

int izracunajSreca(const vector<int>& gornji, const vector<int>& donji) {
    int n = gornji.size();
    int sreca = 0;
    int prethodni = gornji[0];
    for (int i = 0; i < n; i++) {
        if (donji[i] % 2 == prethodni % 2) sreca++;
        prethodni = donji[i];
        if (i < n - 1 && gornji[i + 1] % 2 == prethodni % 2) sreca++;
        prethodni = gornji[i + 1];
    }
    return sreca;
}

void resi(int kolona, vector<int>& gornji, vector<int>& donji, int& maksSreca) {
    if (kolona == gornji.size()) {
        maksSreca = max(maksSreca, izracunajSreca(gornji, donji));
        return;
    }
    resi(kolona + 1, gornji, donji, maksSreca);
    swap(gornji[kolona], donji[kolona]);
    resi(kolona + 1, gornji, donji, maksSreca);
    swap(gornji[kolona], donji[kolona]);
}

int main() {
    int T;
    cin >> T;

    while (T--) {
        int N;
        cin >> N;
        vector<int> gornji(N), donji(N);
        for (int i = 0; i < N; i++) cin >> gornji[i];
        for (int i = 0; i < N; i++) cin >> donji[i];
        int maksSreca = 0;
        resi(0, gornji, donji, maksSreca);
        cout << maksSreca << endl;
    }

    return 0;
}